<div class="col-md-5 col-lg-5 mb-3 mb-lg-5">
    <div class="card h-100">
        <div class="card-header d-flex align-items-center justify-content-between">
            <h5 class="card-title m-0 me-2"><?php echo app('translator')->get('Latest Transactions'); ?></h5>
            <div class="dropdown">
                <span class="p-0" type="button" id="transactionID" data-bs-toggle="dropdown">
                    <i class="bi-three-dots-vertical"></i>
                </span>
                <div class="dropdown-menu dropdown-menu-end" >
                    <a class="dropdown-item" href="<?php echo e(route('user.fund.index')); ?>"><?php echo app('translator')->get('View all transactions'); ?></a>
                </div>
            </div>
        </div>
        <div class="card-body pt-4">
            <ul class="p-0 m-0">
                <?php $__empty_1 = true; $__currentLoopData = $transactions ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <li class="d-flex align-items-center mb-6">
                        <div class="icon icon-md  flex-shrink-0 me-3
                        <?php echo e(($item->trx_type == '+') ? 'icon-soft-success' : 'icon-soft-danger'); ?> ">
                            <i class="<?php echo e(($item->trx_type == '+') ? 'bi-box-arrow-in-down' : 'bi-arrow-left-right'); ?>"></i>
                        </div>
                        <div class="d-flex w-100 flex-wrap align-items-center justify-content-between gap-2">
                            <div class="me-2">
                                <div class="d-block"><?php echo e($item->type); ?></div>
                                <h6 class="fw-normal mb-0"><?php echo e(Str::limit($item->remarks, 25)); ?></h6>
                            </div>
                            <div class="user-progress d-flex align-items-center gap-2">
                                <h4 class="fw-normal mb-0"><?php echo e($item->trx_type); ?><?php echo e($item->amount); ?></h4>
                                <span class="text-body-secondary"><?php echo e(basicControl()->currency_symbol); ?></span>
                            </div>
                        </div>
                    </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <div class="no-data-content">
                        <div class="no-data-image mb-4">
                            <img src="<?php echo e(asset('assets/global/img/oc-error-light.svg')); ?>" alt="No Data" class="img-fluid noDataImage">
                        </div>
                        <h2 class="no-data-title mb-3"><?php echo app('translator')->get('No Data Found'); ?></h2>
                        <p class="no-data-text mb-4"><?php echo app('translator')->get("We couldn't find what you're looking for. Please try again later or modify your search."); ?></p>
                    </div>
                <?php endif; ?>
            </ul>
        </div>
    </div>
</div>
<?php $__env->startPush('style'); ?>
    <style>
        .no-data-content{
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
        }
        .no-data-content img{
            height: 100px;
        }
    </style>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/ygnbmjdo/safarix/resources/views/themes/adventra/user/partials/dashboard/chart.blade.php ENDPATH**/ ?>