
<?php $__env->startSection('page_title', __('PWA')); ?>
<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="page-header">
            <div class="row align-items-end">
                <div class="col-sm mb-2 mb-sm-0">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb breadcrumb-no-gutter">
                            <li class="breadcrumb-item">
                                <a class="breadcrumb-link" href="javascript:void(0)"><?php echo app('translator')->get('Dashboard'); ?>
                                </a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page"><?php echo app('translator')->get('Settings'); ?></li>
                            <li class="breadcrumb-item active" aria-current="page"><?php echo app('translator')->get('PWA'); ?></li>
                        </ol>
                    </nav>
                    <h1 class="page-header-title"><?php echo app('translator')->get('PWA'); ?></h1>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-lg-12">
                <div class="  alert alert-soft-dark " role="alert">
                    <div class="alert-box d-flex flex-wrap align-items-center">
                        <div class="flex-shrink-0">
                            <img class="avatar avatar-xl"
                                 src="<?php echo e(asset('assets/admin/img/oc-megaphone.svg')); ?>"
                                 alt="Image Description" data-hs-theme-appearance="default">
                            <img class="avatar avatar-xl"
                                 src="<?php echo e(asset('assets/admin/img/oc-megaphone-light.svg')); ?>"
                                 alt="Image Description" data-hs-theme-appearance="dark">
                        </div>
                        <div class="flex-grow-1 ms-3">
                            <h3 class="mb-1"><?php echo app('translator')->get("Attention!"); ?></h3>
                            <div class="d-flex align-items-center alertContent">
                                <p class="mb-0 text-body"> <?php echo app('translator')->get('PWA (Progressive Web App) enables enhanced management of your sites’s settings and provides a seamless, app-like experience for users across devices.'); ?></p>
                            </div>
                        </div>
                    </div>
                </div>

            </div>

            <div class="col-lg-3">
                <?php echo $__env->make('admin.control_panel.components.sidebar', ['settings' => config('generalsettings.settings'), 'suffix' => 'Settings'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            </div>
            <div class="col-lg-9" id="basic_control">
                <div class="d-grid gap-3 gap-lg-5">
                    <div class="card">
                        <div class="card-header">
                            <h2 class="card-title h4"><?php echo app('translator')->get('PWA Config'); ?></h2>
                        </div>
                        <div class="card-body">
                            <form action="<?php echo e(route('admin.pwa.create')); ?>" method="post" enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <div class="row mb-3">
                                    <div class="col-sm-6">
                                        <label for="siteTitleLabel" class="form-label"><?php echo app('translator')->get('App Name'); ?></label>
                                        <input type="text"
                                               class="form-control  <?php $__errorArgs = ['app_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                               name="app_name" id="app_name"
                                               placeholder="<?php echo app('translator')->get("app_name"); ?>" aria-label="<?php echo app('translator')->get("App Name"); ?>"
                                               autocomplete="off"
                                               value="<?php echo e(old('app_name', config('pwacontrol.app_name'))); ?>">
                                        <?php $__errorArgs = ['app_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <div class="col-sm-6">
                                        <label for="baseCurrencyLabel" class="form-label"><?php echo app('translator')->get('Short Name'); ?></label>
                                        <input type="text"
                                               class="form-control  <?php $__errorArgs = ['short_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                               name="short_name"
                                               id="baseCurrencyLabel" autocomplete="off"
                                               placeholder="<?php echo app('translator')->get("Short Name"); ?>" aria-label="<?php echo app('translator')->get("Short Name"); ?>"
                                               value="<?php echo e(old('short_name',config('pwacontrol.short_name'))); ?>">
                                        <?php $__errorArgs = ['short_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>

                                <div class="row mb-3">
                                    <div class="col-sm-6">
                                        <label for="background_color"
                                               class="form-label"><?php echo app('translator')->get('Background Color'); ?></label>
                                        <input type="color"
                                               class="form-control color-form-input <?php $__errorArgs = ['background_color'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                               name="background_color"
                                               id="background_color"
                                               placeholder="Primary Color" aria-label="Background Color"
                                               value="<?php echo e(old('background_color',config('pwacontrol.background_color'))); ?>">
                                        <?php $__errorArgs = ['background_color'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <div class="col-sm-6">
                                        <label for="theme_color"
                                               class="form-label"><?php echo app('translator')->get('Theme Color'); ?></label>
                                        <input type="color"
                                               class="form-control color-form-input <?php $__errorArgs = ['theme_color'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                               name="theme_color"
                                               id="theme_color"
                                               placeholder="Theme Color"
                                               aria-label="Theme Color"
                                               value="<?php echo e(old('theme_color',config('pwacontrol.theme_color'))); ?>">
                                        <?php $__errorArgs = ['theme_color'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>

                                <div class="row mb-3">
                                    <div class="col-sm-6">
                                        <label for="display" class="form-label"><?php echo app('translator')->get('Display'); ?></label>
                                        <div class="tom-select-custom">
                                            <select
                                                class="js-select form-select <?php $__errorArgs = ['display'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                id="display" name="display">
                                                <option
                                                    value="fullscreen" <?php if(old('display',config('pwacontrol.display')) == 'fullscreen' ): echo 'selected'; endif; ?>><?php echo app('translator')->get('Fullscreen'); ?></option>
                                                <option
                                                    value="standalone" <?php if(old('display',config('pwacontrol.display')) == 'standalone' ): echo 'selected'; endif; ?>><?php echo app('translator')->get('Standalone'); ?></option>
                                                <option
                                                    value="minimal-ui" <?php if(old('display',config('pwacontrol.display')) == 'minimal-ui' ): echo 'selected'; endif; ?>><?php echo app('translator')->get('Minimal Ui'); ?></option>
                                                <option
                                                    value="browser" <?php if(old('display',config('pwacontrol.display')) == 'browser' ): echo 'selected'; endif; ?>><?php echo app('translator')->get('Browser'); ?></option>
                                            </select>
                                        </div>
                                        <?php $__errorArgs = ['display'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <div class="col-sm-6">
                                        <label for="display" class="form-label"><?php echo app('translator')->get('Status Bar'); ?></label>
                                        <div class="tom-select-custom">
                                            <select
                                                class="js-select form-select <?php $__errorArgs = ['status_bar'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                id="status_bar" name="status_bar">
                                                <option
                                                    value="default" <?php if(old('status_bar',config('pwacontrol.status_bar')) == 'default' ): echo 'selected'; endif; ?>><?php echo app('translator')->get('Default'); ?></option>
                                                <option
                                                    value="black" <?php if(old('status_bar',config('pwacontrol.status_bar')) == 'black' ): echo 'selected'; endif; ?>><?php echo app('translator')->get('Black'); ?></option>
                                                <option
                                                    value="black-translucent" <?php if(old('status_bar',config('pwacontrol.status_bar')) == 'black-translucent' ): echo 'selected'; endif; ?>><?php echo app('translator')->get('Black Translucent'); ?></option>
                                            </select>
                                        </div>
                                        <?php $__errorArgs = ['display'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>

                                <div class="row mb-4">
                                    <div class="col-md-6">
                                        <label class="col-form-label"><?php echo app('translator')->get('Icon'); ?></label>
                                        <label class="form-check form-check-dashed" for="logoUploader">
                                            <img id="logoImg"
                                                 class="avatar avatar-xl avatar-4x3 avatar-centered h-100 mb-2 object-fit-contain"
                                                 src="<?php echo e(collect(config('laravelpwa.manifest.icons'))->first()['path']); ?>"
                                                 alt="<?php echo app('translator')->get("Logo"); ?>"
                                                 data-hs-theme-appearance="default">

                                            <img id="logoImg"
                                                 class="avatar avatar-xl avatar-4x3 avatar-centered h-100 mb-2 object-fit-contain"
                                                 src="<?php echo e(collect(config('laravelpwa.manifest.icons'))->first()['path']); ?>"
                                                 alt="<?php echo app('translator')->get("Logo"); ?>" data-hs-theme-appearance="dark">
                                            <span class="d-block mb-3"><?php echo app('translator')->get("Browse your file here"); ?></span>
                                            <input type="file" class="js-file-attach-logo form-check-input"
                                                   name="icon" id="logoUploader"
                                                   data-hs-file-attach-options='{
                                                      "textTarget": "#logoImg",
                                                      "mode": "image",
                                                      "targetAttr": "src",
                                                      "allowTypes": [".png", ".jpeg", ".jpg", ".svg"]
                                                   }'>
                                        </label>
                                        <?php $__errorArgs = ["logo"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback d-block"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="col-form-label"><?php echo app('translator')->get('Splash'); ?></label>
                                        <label class="form-check form-check-dashed" for="faviconUploader">
                                            <img id="faviconImg"
                                                 class="avatar avatar-xl avatar-4x3 avatar-centered h-100 mb-2 object-fit-contain"
                                                 src="<?php echo e(collect(config('laravelpwa.manifest.splash'))->first()); ?>"
                                                 alt="<?php echo app('translator')->get("Favicon"); ?>"
                                                 data-hs-theme-appearance="default">

                                            <img id="faviconImg"
                                                 class="avatar avatar-xl avatar-4x3 avatar-centered h-100 mb-2 object-fit-contain"
                                                 src="<?php echo e(collect(config('laravelpwa.manifest.splash'))->first()); ?>"
                                                 alt="<?php echo app('translator')->get("Favicon"); ?>" data-hs-theme-appearance="dark">
                                            <span class="d-block mb-3"><?php echo app('translator')->get("Browse your file here"); ?></span>
                                            <input type="file" class="js-file-attach-favicon form-check-input"
                                                   name="splash" id="faviconUploader"
                                                   data-hs-file-attach-options='{
                                                      "textTarget": "#faviconImg",
                                                      "mode": "image",
                                                      "targetAttr": "src",
                                                      "allowTypes": [".png", ".jpeg", ".jpg", ".svg"]
                                                   }'>
                                        </label>
                                        <?php $__errorArgs = ["favicon"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback d-block"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>

                                <div class="d-flex justify-content-start">
                                    <button type="submit" class="btn btn-primary"><?php echo app('translator')->get('Save changes'); ?></button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('css-lib'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/admin/css/tom-select.bootstrap5.css')); ?>">
<?php $__env->stopPush(); ?>
<?php $__env->startPush('js-lib'); ?>
    <script src="<?php echo e(asset('assets/admin/js/tom-select.complete.min.js')); ?>"></script>
    <script src="<?php echo e(asset("assets/admin/js/hs-file-attach.min.js")); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        'use strict';
        $( document ).ready(function() {
            HSCore.components.HSTomSelect.init('.js-select', {
                maxOptions: 500
            })
            new HSFileAttach('.js-file-attach-logo', {
                textTarget: "#logoImg"
            });
            new HSFileAttach('.js-file-attach-favicon', {
                textTarget: "#faviconImg"
            });
        })
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ygnbmjdo/safarix/resources/views/admin/control_panel/pwa.blade.php ENDPATH**/ ?>