<?php if(isset($tour_places) && !empty($tour_places['single'])): ?>
    <section class="tour-places-section-4 fix section-padding section-bg">
        <div class="container">
            <div class="section-title text-center">
                <span class="wow fadeInUp"><?php echo e($tour_places['single']['title'] ?? ''); ?></span>
                <h2 class="wow fadeInUp" data-wow-delay=".3s">
                    <?php echo e($tour_places['single']['sub_title'] ?? ''); ?>

                </h2>
                <p class="mt-3 wow fadeInUp" data-wow-delay=".5s">
                    <?php echo e($tour_places['single']['description_one'] ?? ''); ?>  <br> <?php echo e($tour_places['single']['description_two'] ?? ''); ?>

                </p>
            </div>
            <div class="row">
                <div class="col-lg-12">
                    <?php $__currentLoopData = $tour_places['places'] ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                        <div class="tour-places-wrapper-4 wow fadeInUp" data-wow-delay=".3s">
                            <div class="content">
                                <span><?php echo e($item->countryTake?->name); ?></span>
                                <h3><a href="<?php echo e(route('package.details', $item->slug)); ?>"><?php echo e($item->title); ?></a></h3>
                                <p><?php echo e(Str::limit(strip_tags($item->description), 80)); ?></p>
                            </div>
                            <ul class="list">
                                <li class="d-flex align-items-center gap-1">
                                    <?php echo displayStarRating($item->avg_rating); ?>

                                    <span>(<?php echo e($item->reviews_count ?? 0); ?>) <?php echo app('translator')->get('Reviews'); ?></span>
                                </li>
                                <?php if(isset($item->address)): ?>
                                    <li>
                                        <i class="fas fa-map-marker-alt"></i>
                                        <?php echo e($item->address); ?>

                                    </li>
                                <?php endif; ?>
                                <?php if(isset($item->duration)): ?>
                                    <li>
                                        <i class="far fa-calendar-minus"></i>
                                        <?php echo e($item->duration); ?>

                                    </li>
                                <?php endif; ?>
                            </ul>
                            <div class="thumb">
                                <img src="<?php echo e(getFile($item->thumb_driver, $item->thumb)); ?>" alt="<?php echo e($item->title); ?>">
                                <span class="price-list">
                                    <span class="price"><?php echo e(currencyPosition($item->adult_price)); ?></span>
                                    <span class="person">/ <?php echo app('translator')->get('person'); ?></span>
                                </span>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </section>
    <style>
        .tour-places-wrapper-4 .list li i{
            margin-right: 0 !important;
        }
    </style>
<?php endif; ?>

<?php /**PATH /home/ygnbmjdo/safarix/resources/views/themes/adventra/sections/tour_places.blade.php ENDPATH**/ ?>