
<?php $__env->startSection('page_title',__('View Profile')); ?>
<?php $__env->startSection('content'); ?>

    <!-- Content -->
    <div class="content container-fluid">
        <div class="row justify-content-lg-center">
            <div class="col-lg-10">

                <?php echo $__env->make('admin.user_management.components.header_user_profile', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

                <div class="row">
                    <div class="col-lg-4">
                        <div class="card mb-3 mb-lg-5">
                            <div class="card-header card-header-content-between">
                                <h4 class="card-header-title"><?php echo app('translator')->get('Profile'); ?></h4>
                            </div>

                            <div class="card-body">
                                <ul class="list-unstyled list-py-2 text-dark mb-0">
                                    <li class="pb-0"><span class="card-subtitle"><?php echo app('translator')->get('About'); ?></span></li>
                                    <li>
                                        <i class="bi-person dropdown-item-icon"></i> <?php echo app('translator')->get($user->firstname . ' ' . $user->lastname); ?>
                                    </li>
                                    <li><i class="bi-briefcase dropdown-item-icon"></i> <?php echo app('translator')->get('@' . $user->username); ?>
                                    </li>
                                    <?php if(isset($user->country)): ?>
                                    <li><i class="bi-geo-alt dropdown-item-icon"></i> <?php echo app('translator')->get($user->country); ?></li>
                                    <?php endif; ?>

                                    <li><i class="bi bi-wallet dropdown-item-icon"></i> <?php echo e(currencyPosition($user->balance)); ?>

                                    </li>

                                    <li class="pt-4 pb-0"><span class="card-subtitle"><?php echo app('translator')->get('Contacts'); ?></span></li>
                                    <li>
                                        <i class="bi-at dropdown-item-icon"></i> <?php echo e($user->email); ?>

                                        <i
                                            class="bi-patch-check-fill text-<?php echo e($user->email_verification == 1 ? 'success' : 'danger'); ?>"
                                            data-bs-toggle="tooltip"
                                            data-bs-placement="top"
                                            aria-label="<?php echo e($user->email_verification == 1 ? 'Email Verified' : 'Email Unverified'); ?>"
                                            data-bs-original-title="<?php echo e($user->email_verification == 1 ? 'Email Verified' : 'Email Unverified'); ?>">
                                        </i>
                                    </li>
                                    <li><i class="bi-phone dropdown-item-icon"></i> <?php echo e($user->phone); ?></li>
                                </ul>
                            </div>
                        </div>

                        <!-- Card -->
                        <div class="card card-lg mb-3 mb-lg-5">
                            <div class="card-body text-center">
                                <div class="mb-4">
                                    <img class="avatar avatar-xl avatar-4x3"
                                         src="<?php echo e(asset('assets/admin/img/oc-unlock.svg')); ?>" alt="Image Description"
                                         data-hs-theme-appearance="default"/>
                                    <img class="avatar avatar-xl avatar-4x3"
                                         src="<?php echo e(asset('assets/admin/img/oc-unlock-light.svg')); ?>"
                                         alt="Image Description"
                                         data-hs-theme-appearance="dark"/>
                                </div>
                                <div class="mb-3">
                                    <h3><?php echo app('translator')->get('2-step verification'); ?></h3>
                                    <p><?php echo app('translator')->get('Protect your account now and enable 2-step verification in the settings.'); ?></p>
                                </div>
                                <form action="<?php echo e(route('admin.user.twoFa.update', $user->id)); ?>" method="post">
                                    <?php echo csrf_field(); ?>
                                    <button type="submit"
                                            class="btn btn-<?php echo e($user->two_fa_verify == 1 ? 'danger' : 'primary'); ?>"
                                            name="two_fa_security" value="<?php echo e($user->two_fa_verify); ?>">
                                        <?php echo e($user->two_fa_verify == 1 ? 'Disable now' : 'Enable now'); ?>

                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-8">
                        <div class="card card-centered mb-3 mb-lg-5">
                            <div class="card-header card-header-content-between">
                                <h4 class="card-header-title"><?php echo app('translator')->get('Transaction'); ?></h4>
                            </div>


                            <?php if(count($transactions) == 0): ?>
                                <div class="card-body card-body-height">
                                    <img class="avatar avatar-xxl mb-3"
                                         src="<?php echo e(asset('assets/admin/img/oc-error.svg')); ?>"
                                         alt="Image Description" data-hs-theme-appearance="default"/>
                                    <img class="avatar avatar-xxl mb-3"
                                         src="<?php echo e(asset('assets/admin/img/oc-error-light.svg')); ?>"
                                         alt="Image Description" data-hs-theme-appearance="dark"/>
                                    <p class="card-text"><?php echo app('translator')->get('No data to show'); ?></p>
                                </div>
                            <?php endif; ?>

                            <?php if(0 < count($transactions)): ?>
                                <div class="table-responsive">
                                    <table
                                        class="table table-thead-bordered table-nowrap table-align-middle card-table">
                                        <thead class="thead-light">
                                        <tr>
                                            <th><?php echo app('translator')->get('No.'); ?></th>
                                            <th><?php echo app('translator')->get('TRX'); ?></th>
                                            <th><?php echo app('translator')->get('Amount'); ?></th>
                                            <th><?php echo app('translator')->get('Remarks'); ?></th>
                                            <th><?php echo app('translator')->get('Date-Time'); ?></th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key =>  $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                            <tr>
                                                <td>
                                                    <?php echo e($loop->index + 1); ?>

                                                </td>
                                                <td>
                                                    <?php echo e($transaction->trx_id); ?>

                                                </td>
                                                <td>
                                                    <h6 class="mb-0 <?php echo e($transaction->trx_type == '+' ? 'text-success' : 'text-danger'); ?>"><?php echo e($transaction->trx_type . currencyPosition($transaction->amount)); ?></h6>
                                                </td>
                                                <td> <?php echo app('translator')->get($transaction->remarks); ?></td>
                                                <td><?php echo e(dateTime($transaction->created_at, 'd M Y h:i A')); ?></td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>

                                        <?php endif; ?>
                                        </tbody>
                                    </table>
                                </div>
                            <?php endif; ?>
                        </div>


                        <div class="card card-centered mb-3 mb-lg-5">
                            <div class="card-header card-header-content-between">
                                <h4 class="card-header-title"><?php echo app('translator')->get('Payment Log'); ?></h4>
                            </div>

                            <?php if(count($paymentLog) == 0): ?>
                                <div class="card-body card-body-height card-body-centered">
                                    <img class="avatar avatar-xxl mb-3"
                                         src="<?php echo e(asset('assets/admin/img/oc-error.svg')); ?>"
                                         alt="Image Description" data-hs-theme-appearance="default"/>
                                    <img class="avatar avatar-xxl mb-3"
                                         src="<?php echo e(asset('assets/admin/img/oc-error.svg')); ?>"
                                         alt="Image Description" data-hs-theme-appearance="dark"/>
                                    <p class="card-text"><?php echo app('translator')->get('No data to show'); ?></p>
                                </div>
                            <?php endif; ?>

                            <?php if(0 < count($paymentLog)): ?>
                                <div class="table-responsive">
                                    <table
                                        class="table table-thead-bordered table-nowrap table-align-middle card-table">
                                        <thead class="thead-light">
                                        <tr>
                                            <th><?php echo app('translator')->get('No.'); ?></th>
                                            <th><?php echo app('translator')->get('TRX'); ?></th>
                                            <th><?php echo app('translator')->get('Method'); ?></th>
                                            <th><?php echo app('translator')->get('Amount'); ?></th>
                                            <th><?php echo app('translator')->get('status'); ?></th>
                                            <th><?php echo app('translator')->get('Date'); ?></th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php $__empty_1 = true; $__currentLoopData = $paymentLog; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key =>  $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                            <tr>
                                                <td>
                                                    <?php echo e($loop->index + 1); ?>

                                                </td>
                                                <td>
                                                    <?php echo e($payment->trx_id); ?>

                                                </td>
                                                <td>
                                                    <a class="d-flex align-items-center" href="javascript:void(0)">
                                                        <div class="avatar avatar-circle">
                                                            <img class="avatar-img"
                                                                 src="<?php echo e(getFile(optional($payment->gatewayable)->driver, optional($payment->gatewayable)->image)); ?>"
                                                                 alt="Image Description">
                                                        </div>
                                                        <div class="ms-3">
                                                            <span
                                                                class="d-block h5 text-inherit mb-0"><?php echo app('translator')->get(optional($payment->gatewayable)->name); ?></span>
                                                        </div>
                                                    </a>
                                                </td>
                                                <td>
                                                    <h6 class="mb-0 <?php echo e($payment->getStatusClass()); ?>"><?php echo e(currencyPosition($payment->payable_amount_in_base_currency)); ?></h6>
                                                </td>
                                                <td>
                                                    <?php if($payment->status == 1): ?>
                                                        <span
                                                            class="badge bg-soft-success text-success"><?php echo app('translator')->get('Successful'); ?></span>
                                                    <?php elseif($payment->status == 2): ?>
                                                        <span
                                                            class="badge bg-soft-warning text-warning"><?php echo app('translator')->get('Pending'); ?></span>
                                                    <?php elseif($payment->status == 3): ?>
                                                        <span
                                                            class="badge bg-soft-danger text-danger"><?php echo app('translator')->get('Cancel'); ?></span>
                                                    <?php elseif($payment->status == 4): ?>
                                                        <span
                                                            class="badge bg-soft-danger text-danger"><?php echo app('translator')->get('Failed'); ?></span>
                                                    <?php endif; ?>
                                                </td>
                                                <td><?php echo e(dateTime($payment->created_at, 'd M Y h:i A')); ?></td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>

                                        <?php endif; ?>
                                        </tbody>
                                    </table>
                                </div>
                            <?php endif; ?>

                        </div>
                        <div class="card card-centered mb-3 mb-lg-5">
                            <div class="card-header card-header-content-between">
                                <h4 class="card-header-title"><?php echo app('translator')->get('Withdraw Log'); ?></h4>
                            </div>

                            <?php if(count($withDraws) == 0): ?>
                                <div class="card-body card-body-height card-body-centered">
                                    <img class="avatar avatar-xxl mb-3"
                                         src="<?php echo e(asset('assets/admin/img/oc-error.svg')); ?>"
                                         alt="Image Description" data-hs-theme-appearance="default"/>
                                    <img class="avatar avatar-xxl mb-3"
                                         src="<?php echo e(asset('assets/admin/img/oc-error.svg')); ?>"
                                         alt="Image Description" data-hs-theme-appearance="dark"/>
                                    <p class="card-text"><?php echo app('translator')->get('No data to show'); ?></p>
                                </div>
                            <?php endif; ?>

                            <?php if(0 < count($withDraws)): ?>
                                <div class="table-responsive">
                                    <table
                                        class="table table-thead-bordered table-nowrap table-align-middle card-table">
                                        <thead class="thead-light">
                                        <tr>
                                            <th><?php echo app('translator')->get('No.'); ?></th>
                                            <th><?php echo app('translator')->get('TRX'); ?></th>
                                            <th><?php echo app('translator')->get('Method'); ?></th>
                                            <th><?php echo app('translator')->get('Amount'); ?></th>
                                            <th><?php echo app('translator')->get('status'); ?></th>
                                            <th><?php echo app('translator')->get('Date'); ?></th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php $__empty_1 = true; $__currentLoopData = $withDraws; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key =>  $withdraw): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                            <tr>
                                                <td>
                                                    <?php echo e($loop->index + 1); ?>

                                                </td>
                                                <td>
                                                    <?php echo e($withdraw->trx_id); ?>

                                                </td>
                                                <td>
                                                    <a class="d-flex align-items-center" href="javascript:void(0)">
                                                        <div class="avatar avatar-circle">
                                                            <img class="avatar-img"
                                                                 src="<?php echo e(getFile(optional($withdraw->method)->driver, optional($withdraw->method)->logo)); ?>"
                                                                 alt="Image Description">
                                                        </div>
                                                        <div class="ms-3">
                                                            <span
                                                                class="d-block h5 text-inherit mb-0"><?php echo app('translator')->get(optional($withdraw->method)->name); ?></span>
                                                        </div>
                                                    </a>
                                                </td>
                                                <td>
                                                    <h6 class="mb-0 <?php echo e($withdraw->getStatusClass()); ?>"><?php echo e(currencyPosition($withdraw->amount_in_base_currency)); ?></h6>
                                                </td>
                                                <td>
                                                    <?php if($withdraw->status == 1): ?>
                                                        <span
                                                            class="badge bg-soft-warning text-warning"><?php echo app('translator')->get('Pending'); ?></span>
                                                    <?php elseif($withdraw->status == 2): ?>
                                                        <span
                                                            class="badge bg-soft-success text-success"><?php echo app('translator')->get('Successful'); ?></span>
                                                    <?php elseif($withdraw->status == 3): ?>
                                                        <span
                                                            class="badge bg-soft-danger text-danger"><?php echo app('translator')->get('Cancel'); ?></span>
                                                    <?php endif; ?>
                                                </td>
                                                <td><?php echo e(dateTime($withdraw->created_at, 'd M Y h:i A')); ?></td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>

                                        <?php endif; ?>
                                        </tbody>
                                    </table>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>


    <?php echo $__env->make('admin.user_management.components.login_as_user', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <?php echo $__env->make('admin.user_management.components.update_balance_modal', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <?php echo $__env->make('admin.user_management.components.block_profile_modal', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<?php $__env->stopSection(); ?>


<?php $__env->startPush('script'); ?>
    <script>
        'use strict';
        $(document).on('click', '.loginAccount', function () {
            let route = $(this).data('route');
            $('.loginAccountAction').attr('action', route)
        });

        $(document).on('click', '.blockProfile', function () {
            let route = $(this).data('route');
            $('.blockProfileAction').attr('action', route)
        });

    </script>
<?php $__env->stopPush(); ?>








<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ygnbmjdo/safarix/resources/views/admin/user_management/user_view_profile.blade.php ENDPATH**/ ?>