<?php if(isset($tour_three) && !empty($tour_three['single'])): ?>
    <section class="tour-section section-padding fix bg-cover section-bg" style="background-image: url(<?php echo e(getFile($tour_three['single']['media']->background_image->driver, $tour_three['single']['media']->background_image->path)); ?>);">
        <div class="container">
            <div class="section-title text-center">
                <span class="wow fadeInUp"><?php echo e($tour_three['single']['title'] ?? ''); ?></span>
                <h2 class="wow fadeInUp" data-wow-delay=".3s"><?php echo e($tour_three['single']['sub_title'] ?? ''); ?></h2>
            </div>
            <div class="row">
                <?php $__currentLoopData = $tour_three['packages'] ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-xl-4 col-lg-6 col-md-6 wow fadeInUp" data-wow-delay=".3s">
                        <div class="tour-box-items-2">
                            <div class="tour-image">
                                <img src="<?php echo e(getFile($item->thumb_driver, $item->thumb)); ?>" alt="<?php echo e($item->title); ?>">
                                <div class="post-bar">
                                    <?php if($item->is_featured == 1): ?>
                                        <div class="post">
                                            <?php echo app('translator')->get('FEATURED'); ?>
                                        </div>
                                    <?php endif; ?>
                                    <?php if($item->discount == 1): ?>
                                        <div class="post bg-color">
                                            <?php if($item->discount_type == 0): ?>
                                                <?php echo e($item->discount_amount.'% OFF'); ?>

                                            <?php elseif($item->discount_type == 1): ?>
                                                <?php echo e(currencyPosition($item->discount_amount).' OFF'); ?>

                                            <?php endif; ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="tour-content">
                                <h3>
                                    <a href="<?php echo e(route('package.details', $item->slug)); ?>">
                                        <?php echo e($item->title); ?>

                                    </a>
                                </h3>
                                <?php if(isset($item->address)): ?>
                                    <ul class="meta">
                                        <li>
                                            <i class="fal fa-map-marker-alt"></i>
                                            <?php echo e($item->address); ?>

                                        </li>
                                    </ul>
                                <?php endif; ?>

                                <div class="rating-bar">
                                    <ul class="rating">
                                        <li>
                                            <i class="fas fa-star"></i>
                                            <?php echo e($item->avg_rating ?? 0); ?> <?php echo app('translator')->get('BY'); ?> <?php echo e($item->reviews_count ?? 0); ?> <?php echo app('translator')->get('REVIEWS'); ?>
                                        </li>
                                    </ul>
                                    <ul class="icon">
                                        <?php if(!empty($item->video)): ?>
                                            <li>
                                                <a href="<?php echo e($item->video); ?>" class="tour-three-popup-video">
                                                    <i class="fal fa-video"></i>
                                                </a>
                                            </li>
                                        <?php endif; ?>
                                        <?php if(isset($item->media) && $item->media->count() > 0): ?>
                                            <?php
                                                $images = [];

                                                foreach ($item->media as $media){
                                                    $images[] = getFile($media->driver, $media->image);
                                                }
                                            ?>
                                            <ul>
                                                <li>
                                                    <a href="#" data-images='<?php echo json_encode($images, 15, 512) ?>' class="tour-three-popup-image">
                                                        <i class="fal fa-camera-alt"></i>
                                                    </a>
                                                </li>
                                            </ul>
                                        <?php endif; ?>
                                    </ul>
                                </div>
                                <div class="tour-btn">
                                    <a href="<?php echo e(route('package.details', $item->slug)); ?>" class="theme-btn">
                                        <span><?php echo app('translator')->get('Book Now'); ?></span> <i class="far fa-long-arrow-right"></i>
                                    </a>
                                    <h2><?php echo e(discountPrice($item)); ?>/<span>/<?php echo app('translator')->get('per person'); ?></span></h2>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </section>
<?php endif; ?>

<?php /**PATH /home/ygnbmjdo/safarix/resources/views/themes/adventra/sections/tour_three.blade.php ENDPATH**/ ?>