
<?php $__env->startSection('page_title', __('Manage Gateways')); ?>
<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="row justify-content-lg-center">
            <div class="col-lg-10">
                <div class="page-header custom-header">
                    <div class="row">
                        <div class="col-sm mb-2 mb-sm-0 d-flex align-items-center justify-content-between">
                            <div class="left">
                                <nav aria-label="breadcrumb">
                                    <ol class="breadcrumb breadcrumb-no-gutter">
                                        <li class="breadcrumb-item"><a class="breadcrumb-link" href="javascript:void(0);"><?php echo app('translator')->get('Dashboard'); ?></a></li>
                                        <li class="breadcrumb-item active" aria-current="page"><?php echo app('translator')->get('Manage Gateways'); ?></li>
                                    </ol>
                                </nav>
                                <h1 class="page-header-title"><?php echo app('translator')->get('Manage Gateways'); ?></h1>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title"><?php echo app('translator')->get('Available gateways'); ?></h4>
                    </div>

                    <!-- Body -->
                    <div class="card-body pt-0">
                        <div class="list-group list-group-lg list-group-flush list-group-no-gutters">
                            <?php $__empty_1 = true; $__currentLoopData = $gateways ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <div class="list-group-item">
                                    <div class="d-flex">
                                        <div class="flex-shrink-0">
                                            <img class="avatar avatar-xs" src="<?php echo e(getFile($item->driver, $item->image)); ?>" alt="<?php echo e($item->name); ?>">
                                        </div>

                                        <div class="flex-grow-1 ms-3">
                                            <div class="row align-items-center">
                                                <div class="col">
                                                    <h4 class="mb-0"><?php echo e($item->name); ?></h4>
                                                    <?php $__currentLoopData = $item->supported_currency ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <span class="badge bg-secondary bg-opacity-25 text-dark">
                                                            <?php echo e($currency); ?>

                                                        </span>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </div>

                                                <div class="col-auto">
                                                    <input type="hidden" name="status" value="0">

                                                    <div class="form-check form-switch">
                                                        <input
                                                            class="form-check-input"
                                                            type="checkbox"
                                                            id="statusChecked"
                                                            name="status"
                                                            value="1"
                                                            data-id="<?php echo e($item->id); ?>"
                                                            <?php echo e($item->status ? 'checked' : ''); ?>

                                                        >
                                                        <label class="form-check-label" for="statusChecked"></label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <?php echo $__env->make('empty', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('script'); ?>
    <script>
        $(document).ready(function() {
            $('.form-check-input').on('change', function() {
                let status = $(this).is(':checked') ? 1 : 0;
                let id = $(this).data('id');

                $.ajax({
                    url: '<?php echo e(route('user.payment.gateway.update.status')); ?>',
                    method: 'POST',
                    data: {
                        _token: '<?php echo e(csrf_token()); ?>',
                        id: id,
                        status: status
                    },
                    success: function(response) {
                        if(response.status == 1){
                            Notiflix.Notify.success(response.msg);
                        }else{
                            Notiflix.Notify.failure(response.msg);
                        }
                    },
                    error: function(xhr) {
                        let message = 'Status update failed';

                        if (xhr.responseJSON && xhr.responseJSON.error) {
                            message = xhr.responseJSON.error;
                        }
                        Notiflix.Notify.failure(message);
                    }
                });
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make(template().'layouts.user', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ygnbmjdo/safarix/resources/views/themes/adventra/user/gateway/manage.blade.php ENDPATH**/ ?>