<div class="profile-cover">
    <div class="profile-cover-img-wrapper">
        <img id="profileCoverImg" class="profile-cover-img" src="<?php echo e(asset('assets/admin/img/img1.jpg')); ?>"
             alt="Image Description"/>
    </div>
</div>

<div class="text-center mb-5">
    <label class="avatar avatar-xxl avatar-circle avatar-uploader profile-cover-avatar"
           for="editAvatarUploaderModal">
        <img id="editAvatarImgModal" class="avatar-img"
             src="<?php echo e(getFile($user->image_driver, $user->image)); ?>" alt="Image Description"/>
    </label>

    <h1 class="page-header-title">
        <?php echo app('translator')->get($user->firstname. ' ' . $user->lastname); ?>
        <?php if($user->email_verification && $user->sms_verification): ?>
            <i class="<?php echo e($user->status == 1 ? 'bi-patch-check-fill' : 'bi bi-x-circle'); ?>  fs-2 <?php echo e($user->status == 1 ? 'text-primary' : 'text-danger'); ?> " data-bs-toggle="tooltip"
               data-bs-placement="top"
               title="<?php echo e($user->status == 1 ? 'Verified Profile' : 'Blocked Profile'); ?>"></i>
        <?php endif; ?>
    </h1>

    <ul class="list-inline list-px-2">
        <?php if(!empty($user->city) || !empty($user->country)): ?>
            <li class="list-inline-item">
                <i class="bi-geo-alt me-1"></i>
                <?php if(!empty($user->city)): ?>
                    <span><?php echo app('translator')->get($user->city); ?></span>
                    <?php if(!empty($user->country)): ?>
                        <span>,</span>
                    <?php endif; ?>
                <?php endif; ?>
                <?php if(!empty($user->country)): ?>
                    <span><?php echo app('translator')->get($user->country); ?></span>
                <?php endif; ?>
            </li>
        <?php endif; ?>

        <li class="list-inline-item">
            <i class="bi-calendar-week me-1"></i>
            <span><?php echo e('Joined ' . dateTime($user->created_at, 'M Y')); ?></span>
        </li>
    </ul>
</div>

<div class="js-nav-scroller hs-nav-scroller-horizontal mb-5">
    <span class="hs-nav-scroller-arrow-prev display-none">
        <a class="hs-nav-scroller-arrow-link" href="javascript:void(0)">
            <i class="bi-chevron-left"></i>
        </a>
    </span>

    <span class="hs-nav-scroller-arrow-next display-none">
        <a class="hs-nav-scroller-arrow-link" href="javascript:void(0)">
            <i class="bi-chevron-right"></i>
        </a>
    </span>

    <ul class="nav nav-tabs align-items-center">
        <li class="nav-item">
            <a class="nav-link <?php echo e(request()->routeIs('admin.user.view.profile') ? 'active' : ''); ?>"
               href="<?php echo e(route('admin.user.view.profile', $user->id)); ?>"><?php echo app('translator')->get('Profile'); ?></a>
        </li>
        <li class="nav-item">
            <a class="nav-link <?php echo e(request()->routeIs('admin.user.transaction') ? 'active' : ''); ?>"
               href="<?php echo e(route('admin.user.transaction', $user->id)); ?>"><?php echo app('translator')->get('Transaction'); ?></a>
        </li>
        <li class="nav-item">
            <a class="nav-link <?php echo e(request()->routeIs('admin.user.payment') ? 'active' : ''); ?>"
               href="<?php echo e(route('admin.user.payment', $user->id)); ?>"><?php echo app('translator')->get('Payment History'); ?></a>
        </li>
        <li class="nav-item">
            <a class="nav-link <?php echo e(request()->routeIs('admin.user.payout') ? 'active' : ''); ?>"
               href="<?php echo e(route('admin.user.payout', $user->id)); ?>"><?php echo app('translator')->get('Withdraw History'); ?>
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link <?php echo e(request()->routeIs('admin.user.kyc.list') ? 'active' : ''); ?>"
               href="<?php echo e(route('admin.user.kyc.list', $user->id)); ?>"><?php echo app('translator')->get('KYC Verification'); ?></a>
        </li>

        <li class="nav-item ms-auto">
            <div class="d-flex gap-2">
                <a class="btn btn-white btn-sm" href="<?php echo e(route('admin.user.edit', $user->id)); ?>"> <i
                        class="bi-person-plus-fill me-1"></i> <?php echo app('translator')->get('Edit profile'); ?> </a>
                <div class="dropdown nav-scroller-dropdown">
                    <button type="button" class="btn btn-white btn-icon btn-sm" id="profileDropdown"
                            data-bs-toggle="dropdown" aria-expanded="false">
                        <i class="bi-three-dots-vertical"></i>
                    </button>

                    <div class="dropdown-menu dropdown-menu-end mt-1" aria-labelledby="profileDropdown">
                        <span class="dropdown-header"><?php echo app('translator')->get('Settings'); ?></span>
                        <a class="dropdown-item" href="<?php echo e(route('admin.send.email', $user->id)); ?>"> <i
                                class="bi-envelope dropdown-item-icon"></i> <?php echo app('translator')->get('Send Mail'); ?> </a>
                        <a class="dropdown-item blockProfile" href="javascript:void(0)"
                           data-route="<?php echo e(route('admin.block.profile', $user->id)); ?>"
                           data-bs-toggle="modal" data-bs-target="#blockProfileModal">
                            <i class="<?php echo e(($user->status == 1) ? 'bi-plus-circle' : 'bi-plus-circle'); ?>  dropdown-item-icon"></i><?php echo app('translator')->get($user->status == 1 ? 'Block Profile' : 'Unblock Profile'); ?>  </a>
                        <a class="dropdown-item loginAccount" href="javascript:void(0)"
                           data-route="<?php echo e(route('admin.login.as.user', $user->id)); ?>"
                           data-bs-toggle="modal" data-bs-target="#loginAsUserModal">
                            <i class="bi bi-box-arrow-in-right dropdown-item-icon"></i>
                            <?php echo app('translator')->get('Login As User'); ?>
                        </a>
                        <a class="dropdown-item addBalance" href="javascript:void(0)"
                           data-route="<?php echo e(route('admin.user.update.balance', $user->id)); ?>"
                           data-balance="<?php echo e(currencyPosition($user->balance)); ?>"
                           data-bs-toggle="modal" data-bs-target="#addBalanceModal">
                            <i class="bi bi-cash-coin dropdown-item-icon"></i>
                            <?php echo app('translator')->get('Manage Balance'); ?>
                        </a>
                    </div>
                </div>
            </div>
        </li>
    </ul>
</div>

<?php $__env->startPush("script"); ?>
    <script>
        "use script";
        $(document).on('click', '.addBalance', function () {
            $('.setBalanceRoute').attr('action', $(this).data('route'));
            $('.user-balance').text($(this).data('balance'));
        })
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/ygnbmjdo/safarix/resources/views/admin/user_management/components/header_user_profile.blade.php ENDPATH**/ ?>