<!DOCTYPE html>
<html lang="<?php echo e(session()->get('lang')); ?>" dir="<?php echo e(optional(defaultLang())->rtl == 1 ? 'rtl' : 'ltr'); ?>">

<head>
    <meta charset="utf-8">
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <meta content="<?php echo e(isset($pageSeo['meta_description']) ? $pageSeo['meta_description'] : ''); ?>" name="description">
    <meta content="<?php echo e(is_array(@$pageSeo['meta_keywords']) ? implode(', ', @$pageSeo['meta_keywords']) : @$pageSeo['meta_keywords']); ?>" name="keywords">
    <meta name="theme-color" content="<?php echo e(basicControl()->primary_color); ?>">
    <meta name="author" content="<?php echo e(basicControl()->site_title); ?>">
    <meta name="robots" content="<?php echo isset($pageSeo['meta_robots']) ? $pageSeo['meta_robots'] : ''; ?>">

    <meta property="og:type" content="website">
    <meta property="og:site_name" content="<?php echo e(isset(basicControl()->site_title) ? basicControl()->site_title : ''); ?>">
    <meta property="og:title" content="<?php echo e(isset($pageSeo['meta_title']) ? $pageSeo['meta_title'] : ''); ?>">
    <meta property="og:description" content="<?php echo e(isset($pageSeo['og_description']) ? $pageSeo['og_description'] : ''); ?>">
    <meta property="og:image" content="<?php echo e(@$pageSeo['meta_image']); ?>">
    <meta name="twitter:card" content="<?php echo e(isset($pageSeo['meta_title']) ? $pageSeo['meta_title'] : ''); ?>">
    <meta name="twitter:title" content="<?php echo e(isset($pageSeo['meta_title']) ? $pageSeo['meta_title'] : ''); ?>">
    <meta name="twitter:description" content="<?php echo e(isset($pageSeo['meta_description']) ? $pageSeo['meta_description'] : ''); ?>">
    <meta name="twitter:image" content="<?php echo e(@$pageSeo['meta_image']); ?>">

    <title> <?php echo e(basicControl()->site_title); ?> <?php if(isset($pageSeo['page_title'])): ?>
            | <?php echo e(str_replace(basicControl()->site_title, ' ',$pageSeo['page_title'])); ?>

        <?php else: ?>
             | <?php echo $__env->yieldContent('title'); ?>
        <?php endif; ?></title>

    <!-- Favicons -->
    <link href="<?php echo e(getFile(basicControl()->favicon_driver, basicControl()->favicon)); ?>" rel="icon">

    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i|Nunito:300,300i,400,400i,600,600i,700,700i|Poppins:300,300i,400,400i,500,500i,600,600i,700,700i" rel="stylesheet">

    <!-- Vendor CSS Files -->
    <link href="<?php echo e(asset(template(true) . 'css/all.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset(template(true) . 'css/bootstrap.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset(template(true) . 'css/font-awesome.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset(template(true) . 'css/animate.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset(template(true) . 'css/intlTelInput.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset(template(true) . 'css/magnific-popup.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset(template(true) . 'css/meanmenu.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset(template(true) . 'css/odometer.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset(template(true) . 'css/swiper-bundle.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset(template(true) . 'css/datepickerboot.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset(template(true) . 'css/nice-select.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset(template(true) . 'css/flatpickr.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset(template(true) . 'css/main.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset(template(true) . 'css/style.css')); ?>" rel="stylesheet">

    <?php echo $__env->yieldPushContent('css-lib'); ?>
    <?php echo $__env->yieldPushContent('style'); ?>

    <?php $config = (new \LaravelPWA\Services\ManifestService)->generate(); echo $__env->make( 'laravelpwa::meta' , ['config' => $config])->render(); ?>

</head>

<body class="<?php echo e(optional(defaultLang())->rtl == 1 ? 'rtlSet' : 'ltrSet'); ?>">

<?php echo $__env->make(template().'partials.preloader', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php echo $__env->make(template().'partials.fixed_area', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php if(!Route::is('login') && !Route::is('register')): ?>
    <?php echo $__env->make(template().'partials.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php endif; ?>
<?php if(!request()->is('/') && !request()->is('/')): ?>
    <?php if(isset($pageSeo) && $pageSeo['breadcrumb_status'] == 1): ?>
        <div class="breadcrumb-wrapper section-padding  bg-cover" style="background-image: url(<?php echo e($pageSeo['breadcrumb_image']); ?>);">
            <div class="container-fluid">
                <div class="page-heading">
                    <ul class="breadcrumb-items wow fadeInUp" data-wow-delay=".3s">
                        <li>
                            <a href="<?php echo e(route('page','/')); ?>">
                                <?php echo app('translator')->get('Home'); ?>
                            </a>
                        </li>
                        <li>
                            <span class="slash-icon">/</span>
                        </li>
                        <li>
                            <?php echo e($pageSeo['page_title'] ?? '?'); ?>

                        </li>
                    </ul>
                    <h1 class="wow fadeInUp" data-wow-delay=".5s"><?php echo e($pageSeo['page_title'] ?? '?'); ?></h1>
                </div>
            </div>
            <div class="plane-shape float-bob-x">
                <img src="<?php echo e(asset(template(true).'img/breadcrumb-plane.png')); ?>" alt="img">
            </div>
        </div>
    <?php endif; ?>
<?php endif; ?>
<?php echo $__env->yieldContent('content'); ?>
<?php if(!Route::is('login') && !Route::is('register')): ?>
    <?php echo $__env->make(template().'sections.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php endif; ?>

<button id="back-top" class="back-to-top">
    <i class="fas fa-long-arrow-up"></i>
</button>


<!-- Vendor JS Files -->
<script src="<?php echo e(asset(template(true) . 'js/jquery-3.7.1.min.js')); ?>"></script>
<script src="<?php echo e(asset(template(true) . 'js/bootstrap.bundle.min.js')); ?>"></script>
<script src="<?php echo e(asset(template(true) . 'js/jquery.nice-select.min.js')); ?>"></script>
<script src="<?php echo e(asset(template(true) . 'js/odometer.min.js')); ?>"></script>
<script src="<?php echo e(asset(template(true) . 'js/jquery.appear.min.js')); ?>"></script>
<script src="<?php echo e(asset(template(true) . 'js/bootstrap-datepicker.js')); ?>"></script>
<script src="<?php echo e(asset(template(true) . 'js/swiper-bundle.min.js')); ?>"></script>
<script src="<?php echo e(asset(template(true) . 'js/jquery.meanmenu.min.js')); ?>"></script>
<script src="<?php echo e(asset(template(true) . 'js/jquery.magnific-popup.min.js')); ?>"></script>
<script src="<?php echo e(asset(template(true) . 'js/flatpickr.min.js')); ?>"></script>
<script src="<?php echo e(asset(template(true) . 'js/wow.min.js')); ?>"></script>

<script src="<?php echo e(asset(template(true) . 'js/main.js')); ?>"></script>

<script src="<?php echo e(asset('assets/global/js/notiflix-aio-3.2.6.min.js')); ?>"></script>
<script src="https://www.google.com/recaptcha/api.js" async defer></script>


<?php echo $__env->yieldPushContent('js-lib'); ?>

<?php echo $__env->yieldPushContent('script'); ?>

<?php if(session()->has('success')): ?>
    <script>
        Notiflix.Notify.success("<?php echo app('translator')->get(session('success')); ?>");
    </script>
<?php endif; ?>

<?php if(session()->has('error')): ?>
    <script>
        Notiflix.Notify.failure("<?php echo app('translator')->get(session('error')); ?>");
    </script>
<?php endif; ?>

<?php if(session()->has('warning')): ?>
    <script>
        Notiflix.Notify.warning("<?php echo app('translator')->get(session('warning')); ?>");
    </script>
<?php endif; ?>

<?php echo $__env->make(template().'partials.pwa', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php if(basicControl()->cookie_status == 1 && auth()->user()): ?>
    <?php echo $__env->make(template().'partials.cookie', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php endif; ?>
<?php echo $__env->make('plugins', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
</body>

</html>


<?php /**PATH /home/ygnbmjdo/safarix/resources/views/themes/adventra/layouts/app.blade.php ENDPATH**/ ?>