
<?php $__env->startSection('page_title', __('Dashboard')); ?>
<?php $__env->startSection('content'); ?>
    <div class="content container-fluid dashboard-height">
        <div id="firebase-app">
            <div class="p-3 mb-5 alert alert-soft-dark mb-4 mb-lg-7" role="alert"
                 v-if="notificationPermission == 'default' && !is_notification_skipped" v-cloak>
                <div class="alert-box d-flex flex-wrap align-items-center">
                    <div class="flex-shrink-0">
                        <img class="avatar avatar-xl"
                             src="<?php echo e(asset('assets/admin/img/oc-megaphone.svg')); ?>"
                             alt="Image Description" data-hs-theme-appearance="default">
                        <img class="avatar avatar-xl"
                             src="<?php echo e(asset('assets/admin/img/oc-megaphone-light.svg')); ?>"
                             alt="Image Description" data-hs-theme-appearance="dark">
                    </div>

                    <div class="flex-grow-1 ms-3">
                        <h3 class="mb-1"><?php echo app('translator')->get("Attention!"); ?></h3>
                        <div class="d-flex align-items-center">
                            <p class="mb-0 text-body"> <?php echo app('translator')->get('Please allow your browser to get instant push notification. Allow it from
                                notification setting.'); ?></p>
                            <button id="allow-notification" class="btn btn-sm btn-primary mx-2"><i
                                    class="fa fa-check-circle"></i> <?php echo app('translator')->get('Allow me'); ?></button>
                        </div>
                    </div>
                    <button type="button" class="btn-close"
                            @click.prevent="skipNotification" data-bs-dismiss="alert"
                            aria-label="Close">
                    </button>
                </div>
            </div>
            <div class="alert alert-soft-dark mb-4 mb-lg-7" role="alert"
                 v-if="notificationPermission == 'denied' && !is_notification_skipped" v-cloak>
                <div class="d-flex align-items-center mt-4">
                    <div class="flex-shrink-0">
                        <img class="avatar avatar-xl"
                             src="<?php echo e(asset('assets/admin/img/oc-megaphone.svg')); ?>"
                             alt="Image Description" data-hs-theme-appearance="default">
                        <img class="avatar avatar-xl"
                             src="<?php echo e(asset('assets/admin/img/oc-megaphone-light.svg')); ?>"
                             alt="Image Description" data-hs-theme-appearance="dark">
                    </div>

                    <div class="flex-grow-1 ms-3">
                        <h3 class=" mb-1"><?php echo app('translator')->get("Attention!"); ?></h3>
                        <div class="d-flex align-items-center">
                            <p class="mb-0 text-body"> <?php echo app('translator')->get("Please allow your browser to get instant push notification. Allow it from
                                notification setting."); ?></p>
                        </div>
                    </div>
                    <button type="button" class="btn-close" @click.prevent="skipNotification" data-bs-dismiss="alert"
                            aria-label="Close"></button>
                </div>
            </div>
        </div>

        <div class="row">
            <?php echo $__env->make('admin.partials.dashboard.recentTran', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            <?php echo $__env->make('admin.partials.dashboard.record', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        </div>

        <?php echo $__env->make('admin.partials.dashboard.booking', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        <?php echo $__env->make('admin.partials.dashboard.vendorActivity', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        <?php echo $__env->make('admin.partials.dashboard.worldMap', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

        <div class="card mb-3 mb-lg-5">
            <div class="card-header card-header-content-between">
                <h4 class="card-header-title"><?php echo app('translator')->get("Latest Users"); ?></h4>

                <a class="btn btn-ghost-secondary btn-sm" href="<?php echo e(route("admin.users")); ?>"><?php echo app('translator')->get("View All"); ?></a>
            </div>
            <div class="table-responsive">
                <table class="table table-borderless table-thead-bordered table-align-middle card-table">
                    <thead class="thead-light">
                    <tr>
                        <th><?php echo app('translator')->get('Full Name'); ?></th>
                        <th><?php echo app('translator')->get('Email-Phone'); ?></th>
                        <th><?php echo app('translator')->get('Country'); ?></th>
                        <th><?php echo app('translator')->get('Role'); ?></th>
                        <th><?php echo app('translator')->get('Email Verification'); ?></th>
                        <th><?php echo app('translator')->get('Sms Verification'); ?></th>
                        <th><?php echo app('translator')->get('Status'); ?></th>
                        <th><?php echo app('translator')->get('Action'); ?></th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $latestUser; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td>
                                <a class="d-flex align-items-center me-2"
                                   href="<?php echo e(route("admin.user.view.profile", $user->id)); ?>">
                                    <div class="flex-shrink-0">
                                        <?php echo $user->profilePicture(); ?>

                                    </div>
                                    <div class="flex-grow-1 ms-3">
                                        <h5 class="text-hover-primary mb-0"><?php echo e($user->firstname . ' ' . $user->lastname); ?></h5>
                                        <span class="fs-6 text-body"><?php echo e('@'. $user->username); ?></span>
                                    </div>
                                </a>
                            </td>
                            <td>
                                <span class="d-block h5 mb-0"> <?php echo e($user->email); ?></span>
                                <span class="d-block fs-5"><?php echo e($user->phone_code.$user->phone); ?></span>
                            </td>
                            <td>
                                <?php echo e($user->country ?? 'N/A'); ?>

                            </td>
                            <td>
                                <?php if($user->role == 1): ?>
                                    <span class="badge bg-soft-primary text-primary">
                                        <span class="legend-indicator bg-primary"></span><?php echo app('translator')->get("Vendor"); ?>
                                    </span>
                                <?php else: ?>
                                    <span class="badge bg-secondary text-light">
                                        <span class="legend-indicator bg-light"></span><?php echo app('translator')->get("User"); ?>
                                    </span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($user->email_verification == 1): ?>
                                    <span class="badge bg-soft-info text-info">
                                        <span class="legend-indicator bg-info"></span><?php echo app('translator')->get("Verified"); ?>
                                    </span>
                                <?php else: ?>
                                    <span class="badge bg-warning text-warning">
                                        <span class="legend-indicator bg-warning"></span><?php echo app('translator')->get("Unverified"); ?>
                                    </span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($user->sms_verification == 1): ?>
                                    <span class="badge bg-soft-primary text-primary">
                                        <span class="legend-indicator bg-primary"></span><?php echo app('translator')->get("Verified"); ?>
                                    </span>
                                <?php else: ?>
                                    <span class="badge bg-soft-secondary text-secondary">
                                        <span class="legend-indicator bg-secondary"></span><?php echo app('translator')->get("Unverified"); ?>
                                    </span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($user->status == 1): ?>
                                    <span class="badge bg-soft-success text-success">
                                        <span class="legend-indicator bg-success"></span><?php echo app('translator')->get("Active"); ?>
                                    </span>
                                <?php else: ?>
                                    <span class="badge bg-soft-danger text-danger">
                                        <span class="legend-indicator bg-danger"></span><?php echo app('translator')->get("Inactive"); ?>
                                    </span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <div class="btn-group" role="group">
                                    <a class="btn btn-white btn-sm"
                                       href="<?php echo e(route('admin.user.edit', $user->id)); ?>">
                                        <i class="bi-pencil-fill me-1"></i> <?php echo app('translator')->get("Edit"); ?>
                                    </a>
                                    <div class="btn-group">
                                        <button type="button"
                                                class="btn btn-white btn-icon btn-sm dropdown-toggle dropdown-toggle-empty"
                                                id="userEditDropdown" data-bs-toggle="dropdown"
                                                aria-expanded="false"></button>
                                        <div class="dropdown-menu dropdown-menu-end mt-1"
                                             aria-labelledby="userEditDropdown">
                                            <a class="dropdown-item"
                                               href="<?php echo e(route('admin.user.view.profile', $user->id)); ?>">
                                                <i class="bi-eye-fill dropdown-item-icon"></i> <?php echo app('translator')->get("View Profile"); ?>
                                            </a>
                                            <a class="dropdown-item"
                                               href="<?php echo e(route('admin.send.email', $user->id)); ?>">
                                                <i
                                                    class="bi-envelope dropdown-item-icon"></i> <?php echo app('translator')->get("Send Mail"); ?>
                                            </a>
                                            <a class="dropdown-item loginAccount" href="javascript:void(0)"
                                               data-route="<?php echo e(route('admin.login.as.user', $user->id)); ?>"
                                               data-bs-toggle="modal" data-bs-target="#loginAsUserModal">
                                                <i class="bi bi-box-arrow-in-right dropdown-item-icon"></i>
                                                <?php echo app('translator')->get("Login As User"); ?>
                                            </a>
                                            <a class="dropdown-item addBalance" href="javascript:void(0)"
                                               data-route="<?php echo e(route('admin.user.update.balance', $user->id)); ?>"
                                               data-balance="<?php echo e(currencyPosition($user->balance)); ?>"
                                               data-bs-toggle="modal" data-bs-target="#addBalanceModal">
                                                <i class="bi bi-cash-coin dropdown-item-icon"></i>
                                                <?php echo app('translator')->get("Manage Balance"); ?>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <div class="text-center p-4">
                                <img class="dataTables-image mb-3"
                                     src="<?php echo e(asset('assets/admin/img/oc-error.svg')); ?>"
                                     alt="Image Description" data-hs-theme-appearance="default">
                                <img class="dataTables-image mb-3"
                                     src="<?php echo e(asset('assets/admin/img/oc-error-light.svg')); ?>"
                                     alt="Image Description"
                                     data-hs-theme-appearance="dark">
                                <p class="mb-0"><?php echo app('translator')->get("No data to show"); ?></p>
                            </div>
                        </tr>
                    <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>

        <?php echo $__env->make('admin.partials.dashboard.browserHistory', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    </div>

    <?php if($basicControl->is_active_cron_notification): ?>
        <!-- Modal -->
        <div class="modal fade" id="cron-info" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1"
             aria-labelledby="staticBackdropLabel" aria-hidden="true">
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="staticBackdropLabel"><i class="fal fa-info-circle"></i>
                            <?php echo app('translator')->get('Cron Job Set Up Instruction'); ?></h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-12">
                                <p class="bg-orange text-white p-2">
                                    <i><?php echo app('translator')->get('**To sending emails and manage records automatically you need to setup cron job in your server. Make sure your job is running properly. We insist to set the cron job time as minimum as possible.**'); ?></i>
                                </p>
                            </div>
                            <div class="col-md-12 form-group">
                                <label><strong><?php echo app('translator')->get('Command for Email'); ?></strong></label>
                                <div class="input-group mb-3">
                                    <input type="text" class="form-control copyText"
                                           value="curl -s <?php echo e(route('queue.work')); ?>" disabled>
                                    <button class="input-group-text bg-primary btn btn-primary text-white copy-btn"
                                            id="button-addon2">
                                        <i class="fas fa-copy"></i></button>

                                </div>
                            </div>
                            <div class="col-md-12 form-group">
                                <label><strong><?php echo app('translator')->get('Command for Cron Job'); ?></strong></label>
                                <div class="input-group mb-3">
                                    <input type="text" class="form-control copyText"
                                           value="curl -s <?php echo e(route('schedule:run')); ?>"
                                           disabled>
                                    <button class="input-group-text bg-primary btn btn-primary text-white copy-btn"
                                            id="button-addon2">
                                        <i class="fas fa-copy"></i></button>
                                </div>
                            </div>
                            <div class="col-md-12 text-center">
                                <p class="bg-dark text-white p-2">
                                    <?php echo app('translator')->get('*To turn off this pop up go to '); ?>
                                    <a href="<?php echo e(route('admin.basic.control')); ?>"
                                       class="text-danger"><?php echo app('translator')->get('Basic control'); ?></a>
                                    <?php echo app('translator')->get(' and disable `Cron Set Up Pop Up`.*'); ?>
                                </p>
                            </div>

                            <div class="col-md-12">
                                <p class="text-muted"><span class="text-secondary font-weight-bold"><?php echo app('translator')->get('N.B'); ?>:</span>
                                    <?php echo app('translator')->get('If you are unable to set up cron job, Here is a video tutorial for you'); ?>
                                    <a href="https://www.youtube.com/watch?v=wuvTRT2ety0" target="_blank"><i
                                            class="fab fa-youtube"></i> <?php echo app('translator')->get('Click Here'); ?> </a>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
    <?php echo $__env->make('admin.user_management.components.login_as_user', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <?php echo $__env->make('admin.user_management.components.update_balance_modal', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('js-lib'); ?>
    <script src="<?php echo e(asset('assets/admin/js/chart.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/global/js/apexcharts.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush("script"); ?>
    <script>

        $(document).on('click', '.loginAccount', function () {
            let route = $(this).data('route');
            $('.loginAccountAction').attr('action', route)
        });
        $(document).on('click', '.addBalance', function (){
            $('.setBalanceRoute').attr('action', $(this).data('route'));
            $('.user-balance').text($(this).data('balance'));
        });
        document.querySelectorAll('.js-chart').forEach(item => {
            HSCore.components.HSChartJS.init(item)
        });
        $(document).ready(function () {
            let isActiveCronNotification = '<?php echo e($basicControl->is_active_cron_notification); ?>';
            if (isActiveCronNotification == 1)
                $('#cron-info').modal('show');
            $(document).on('click', '.copy-btn', function () {
                var _this = $(this)[0];
                var copyText = $(this).siblings('input');
                $(copyText).prop('disabled', false);
                copyText.select();
                document.execCommand("copy");
                $(copyText).prop('disabled', true);
                $(this).text('Coppied');
                setTimeout(function () {
                    $(_this).text('');
                    $(_this).html('<i class="fas fa-copy"></i>');
                }, 500)
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php if($firebaseNotify): ?>
    <?php $__env->startPush('script'); ?>
        <script type="module">

            import {initializeApp} from "https://www.gstatic.com/firebasejs/9.17.1/firebase-app.js";
            import {
                getMessaging,
                getToken,
                onMessage
            } from "https://www.gstatic.com/firebasejs/9.17.1/firebase-messaging.js";

            const firebaseConfig = {
                apiKey: "<?php echo e($firebaseNotify['apiKey']); ?>",
                authDomain: "<?php echo e($firebaseNotify['authDomain']); ?>",
                projectId: "<?php echo e($firebaseNotify['projectId']); ?>",
                storageBucket: "<?php echo e($firebaseNotify['storageBucket']); ?>",
                messagingSenderId: "<?php echo e($firebaseNotify['messagingSenderId']); ?>",
                appId: "<?php echo e($firebaseNotify['appId']); ?>",
                measurementId: "<?php echo e($firebaseNotify['measurementId']); ?>"
            };

            const app = initializeApp(firebaseConfig);
            const messaging = getMessaging(app);
            if ('serviceWorker' in navigator) {
                navigator.serviceWorker.register('<?php echo e(getProjectDirectory()); ?>' + `/firebase-messaging-sw.js`, {scope: './'}).then(function (registration) {
                        requestPermissionAndGenerateToken(registration);
                    }
                ).catch(function (error) {
                });
            } else {
            }

            onMessage(messaging, (payload) => {
                if (payload.data.foreground || parseInt(payload.data.foreground) == 1) {
                    const title = payload.notification.title;
                    const options = {
                        body: payload.notification.body,
                        icon: payload.notification.icon,
                    };
                    new Notification(title, options);
                }
            });

            function requestPermissionAndGenerateToken(registration) {
                document.addEventListener("click", function (event) {
                    if (event.target.id == 'allow-notification') {
                        Notification.requestPermission().then((permission) => {
                            if (permission === 'granted') {
                                getToken(messaging, {
                                    serviceWorkerRegistration: registration,
                                    vapidKey: "<?php echo e($firebaseNotify['vapidKey']); ?>"
                                })
                                    .then((token) => {
                                        $.ajax({
                                            url: "<?php echo e(route('admin.save.token')); ?>",
                                            method: "post",
                                            data: {
                                                token: token,
                                            },
                                            success: function (res) {
                                            }
                                        });
                                        window.newApp.notificationPermission = 'granted';
                                    });
                            } else {
                                window.newApp.notificationPermission = 'denied';
                            }
                        });
                    }
                });
            }
        </script>
        <script>
            window.newApp = new Vue({
                el: "#firebase-app",
                data: {
                    admin_foreground: '',
                    admin_background: '',
                    notificationPermission: Notification.permission,
                    is_notification_skipped: sessionStorage.getItem('is_notification_skipped') == '1'
                },
                mounted() {
                    sessionStorage.clear();
                    this.admin_foreground = "<?php echo e($firebaseNotify['admin_foreground']); ?>";
                    this.admin_background = "<?php echo e($firebaseNotify['admin_background']); ?>";
                },
                methods: {
                    skipNotification() {
                        sessionStorage.setItem('is_notification_skipped', '1');
                        this.is_notification_skipped = true;
                    }
                }
            });
        </script>
    <?php $__env->stopPush(); ?>
<?php endif; ?>














<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ygnbmjdo/safarix/resources/views/admin/dashboard-alternative.blade.php ENDPATH**/ ?>