<?php if(isset($plans)): ?>
    <section class="business-pricing-plan pricing">
        <div class="container">
            <div class="common-title sec-title-animation animation-style1">
                <h6><i class="fa-sharp far fa-star-of-life"></i> <?php echo e($plans['single']['title'] ?? ''); ?></h6>
                <h3 class="title-animation"><?php echo e($plans['single']['sub_title'] ?? ''); ?></h3>
            </div>
            <div class="row">
                <?php $__empty_1 = true; $__currentLoopData = $plans['planList'] ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="col-lg-4 col-md-6 mt-4">
                        <div class="business-pricing-card">
                            <div class="business-pricing-card-inner">
                                <div class="badge_area d-flex align-items-center justify-content-center">
                                    <div class="business-pricing-card-badge">
                                        <div class="icon">
                                            <img class="plan_icon" src="<?php echo e(getFile($plan->driver, $plan->image)); ?>" alt="<?php echo e($plan->name.' icon'); ?>"/>
                                        </div>
                                        <h6><?php echo e($plan->name ?? ''); ?></h6>
                                        <?php
                                            if ($plan->validity_type == 'daily'){
                                                $type = 'Days';
                                            }elseif ($plan->validity_type == 'weekly'){
                                                $type = 'Weeks';
                                            }elseif ($plan->validity_type == 'monthly'){
                                                $type = 'Months';
                                            }elseif ($plan->validity_type == 'yearly'){
                                                $type = 'Years';
                                            }else{
                                                $type = 'Unknown';
                                            }
                                        ?>
                                        <p><?php echo e($plan->validity.' '.$type); ?></p>
                                    </div>
                                </div>

                                <div class="business-pricing-card-list">
                                    <ul>
                                        <li><i class="far fa-circle-check"></i> <?php echo e($plan->validity.' '. $type); ?> <?php echo app('translator')->get(' Validity'); ?></li>
                                        <li><i class="far fa-circle-check"></i> <?php echo e($plan->listing_allowed); ?> <?php echo app('translator')->get(' Package Allowed'); ?></li>
                                        <li><i class="far fa-circle-check"></i> <?php echo e($plan->featured_listing); ?> <?php echo app('translator')->get(' Featured Package'); ?></li>
                                        <?php if($plan->ai_feature == 1): ?>
                                            <li><i class="far fa-circle-check"></i> <?php echo app('translator')->get('AI Feature Available'); ?></li>
                                        <?php else: ?>
                                            <li><i class="fas fa-times-circle text-danger"></i> <?php echo app('translator')->get('AI Feature Not Available'); ?></li>
                                        <?php endif; ?>
                                        <?php $__currentLoopData = $plan->features ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li><i class="far fa-circle-check"></i> <?php echo e($feature ?? ''); ?></li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                </div>
                                <div class="pricing-bottom">
                                    <div class="business-pricing-amount"><?php echo e(currencyPosition($plan->price ?? '0')); ?><sub>/<?php echo e($plan->validity.' '.$type); ?></sub></div>
                                    <div class="business-pricing-card-btn">
                                        <form action="<?php echo e(route('user.purchase.planSelect')); ?>" method="POST">
                                            <?php echo csrf_field(); ?>
                                            <input type="hidden" name="selectedPlan" value="<?php echo e($plan->id); ?>">
                                            <button type="submit" class="theme-btn">
                                                <?php echo app('translator')->get('Purchase Now'); ?> <i class="fa-sharp far fa-arrow-right"></i>
                                            </button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <section class="no-data-section section-padding text-center">
                        <div class="container">
                            <div class="row justify-content-center">
                                <div class="col-lg-6">
                                    <div class="no-data-content">
                                        <div class="no-data-image mb-2">
                                            <img src="<?php echo e(asset('assets/global/img/oc-error.svg')); ?>" alt="No Data" class="img-fluid noDataImage">
                                        </div>
                                        <h2 class="no-data-title mb-3"><?php echo app('translator')->get('No Data Found'); ?></h2>
                                        <p class="no-data-text mb-4"><?php echo app('translator')->get("We couldn't find what you're looking for. Please try again later or modify your search."); ?></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>
                    <style>
                        .noDataImage{
                            height: 250px !important;
                            width: 250px !important;
                        }
                    </style>
                <?php endif; ?>
            </div>
        </div>
    </section>
<?php endif; ?>

<?php /**PATH /home/ygnbmjdo/safarix/resources/views/themes/adventra/sections/plans.blade.php ENDPATH**/ ?>