<!-- Card -->
<div id="emailSection" class="card">
    <div class="card-header">
        <h4 class="card-title"><?php echo app('translator')->get('Email'); ?></h4>
    </div>
    <div class="card-body">
        <p><?php echo app('translator')->get('Your current email address is'); ?> <span class="fw-semibold"><?php echo e($user->email); ?></span></p>
        <form action="<?php echo e(route('admin.user.email.update', $user->id)); ?>" method="post">
            <?php echo csrf_field(); ?>
            <div class="row mb-4">
                <label for="newEmailLabel" class="col-sm-3 col-form-label form-label">
                    <?php echo app('translator')->get('New email address'); ?>
                </label>
                <div class="col-sm-9">
                    <input type="email" class="form-control" name="new_email" id="newEmailLabel"
                           placeholder="<?php echo app('translator')->get('Enter new email address'); ?>"
                           aria-label="Enter new email address" autocomplete="off">
                    <?php $__errorArgs = ['new_email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <span class="text-danger"><?php echo e($message); ?></span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>
            <div class="d-flex justify-content-start">
                <button type="submit" class="btn btn-primary"><?php echo app('translator')->get('Save changes'); ?></button>
            </div>
        </form>
    </div>
</div>

<?php /**PATH /home/ygnbmjdo/safarix/resources/views/admin/user_management/components/email_section.blade.php ENDPATH**/ ?>