
<?php $__env->startSection('page_title',trans('Create Package')); ?>
<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="row justify-content-lg-center">
            <div class="col-lg-10">
                <div class="page-header custom-header">
                    <div class="row align-items-end">
                        <div class="col-sm mb-2 mb-sm-0">
                            <nav aria-label="breadcrumb">
                                <ol class="breadcrumb breadcrumb-no-gutter">
                                    <li class="breadcrumb-item"><a class="breadcrumb-link" href="javascript:void(0);"><?php echo app('translator')->get('Dashboard'); ?></a></li>
                                    <li class="breadcrumb-item active" aria-current="page"><?php echo app('translator')->get('Packages'); ?></li>
                                </ol>
                            </nav>
                            <h1 class="page-header-title"><?php echo app('translator')->get('Create Package'); ?></h1>
                        </div>
                        <?php if($freeLimit <= $vendor->posted_listing): ?>
                            <?php if(isset($vendor->active_plan)): ?>
                                <?php if($vendor->current_plan_expiry_date <= now()): ?>
                                    <div class="alert alert-soft-dark" role="alert">
                                        <div class="d-flex align-items-center">
                                            <div class="flex-shrink-0">
                                                <img class="avatar avatar-xl alert_image"
                                                     src="<?php echo e(asset('assets/admin/img/oc-megaphone.svg')); ?>"
                                                     alt="Image Description" data-hs-theme-appearance="default">
                                                <img class="avatar avatar-xl alert_image"
                                                     src="<?php echo e(asset('assets/admin/img/oc-megaphone-light.svg')); ?>"
                                                     alt="Image Description" data-hs-theme-appearance="dark">
                                            </div>

                                            <div class="flex-grow-1 ms-3">
                                                <div class="d-flex align-items-center">
                                                    <p class="mb-0 text-body"><?php echo app('translator')->get('Your plan has expired. Please renew your plan to continue posting.'); ?><a class="btn btn-sm btn-soft-success" href="<?php echo e(route('page', 'plans')); ?>"><?php echo app('translator')->get('Buy Plan'); ?></a></p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php elseif($vendor->plan->listing_allowed <= $vendor->current_plan_posted_listing): ?>
                                    <div class="alert alert-soft-dark" role="alert">
                                        <div class="d-flex align-items-center">
                                            <div class="flex-shrink-0">
                                                <img class="avatar avatar-xl alert_image"
                                                     src="<?php echo e(asset('assets/admin/img/oc-megaphone.svg')); ?>"
                                                     alt="Image Description" data-hs-theme-appearance="default">
                                                <img class="avatar avatar-xl alert_image"
                                                     src="<?php echo e(asset('assets/admin/img/oc-megaphone-light.svg')); ?>"
                                                     alt="Image Description" data-hs-theme-appearance="dark">
                                            </div>

                                            <div class="flex-grow-1 ms-3">
                                                <div class="d-flex align-items-center">
                                                    <p class="mb-0 text-body"><?php echo app('translator')->get('You have reached the maximum listing limit of your current plan. To add more packages, please purchase a new plan.'); ?><a class="btn btn-sm btn-soft-success" href="<?php echo e(route('page', 'plans')); ?>"><?php echo app('translator')->get('Buy Plan'); ?></a></p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            <?php else: ?>
                                <div class="alert alert-soft-dark" role="alert">
                                    <div class="d-flex align-items-center">
                                        <div class="flex-shrink-0">
                                            <img class="avatar avatar-xl alert_image"
                                                 src="<?php echo e(asset('assets/admin/img/oc-megaphone.svg')); ?>"
                                                 alt="Image Description" data-hs-theme-appearance="default">
                                            <img class="avatar avatar-xl alert_image"
                                                 src="<?php echo e(asset('assets/admin/img/oc-megaphone-light.svg')); ?>"
                                                 alt="Image Description" data-hs-theme-appearance="dark">
                                        </div>

                                        <div class="flex-grow-1 ms-3">
                                            <div class="d-flex align-items-center">
                                                <p class="mb-0 text-body"><?php echo app('translator')->get('To create a tour package, please purchase a plan first.'); ?><a class="btn btn-sm btn-soft-success ms-2" href="<?php echo e(route('page', 'plans')); ?>"><?php echo app('translator')->get('Click Here to view plan'); ?></a></p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>
                        <?php endif; ?>
                    </div>
                </div>

                <div class="card mb-3 mb-lg-5">
                    <div class="card-body card-inner">
                        <form action="<?php echo e(route('user.package.store')); ?>" method="post" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>

                            <div class="row justify-content-lg-center">
                                <div class="col-lg-10">
                                    <ul id="addPackageStepFormProgress"
                                        class="js-step-progress step step-sm step-icon-sm step step-inline step-item-between mb-3 mb-md-5">

                                        <li class="step-item">
                                            <a class="step-content-wrapper" href="javascript:void(0);"
                                               data-hs-step-form-next-options='{ "targetSelector": "#stepGeneralInfo" }'>
                                                <span class="step-icon step-icon-soft-dark">1</span>
                                                <div class="step-content">
                                                    <span class="step-title"><?php echo app('translator')->get('General Information'); ?></span>
                                                </div>
                                            </a>
                                        </li>

                                        <li class="step-item">
                                            <a class="step-content-wrapper" href="javascript:void(0);"
                                               data-hs-step-form-next-options='{ "targetSelector": "#stepFacilityDetails" }'>
                                                <span class="step-icon step-icon-soft-dark">2</span>
                                                <div class="step-content">
                                                    <span class="step-title"><?php echo app('translator')->get('Facility and Details'); ?></span>
                                                </div>
                                            </a>
                                        </li>

                                        <li class="step-item">
                                            <a class="step-content-wrapper" href="javascript:void(0);"
                                               data-hs-step-form-next-options='{ "targetSelector": "#stepImages" }'>
                                                <span class="step-icon step-icon-soft-dark">3</span>
                                                <div class="step-content">
                                                    <span class="step-title"><?php echo app('translator')->get('Images'); ?></span>
                                                </div>
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                            </div>

                            <?php echo $__env->make(template().'user.package.partials.add.general_step', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                            <?php echo $__env->make(template().'user.package.partials.add.facility_step', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                            <?php echo $__env->make(template().'user.package.partials.add.image_step', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('style'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/admin/css/tom-select.bootstrap5.css')); ?>">
    <style>

        .inMain {
            margin: 100px 0 !important;
        }
    </style>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('script'); ?>

    <script src="<?php echo e(asset('assets/admin/js/tom-select.complete.min.js')); ?>"></script>
    <script>
        "use strict";

        $(document).ready(function(){
            ['#amenities', '#country', '#state', '#city', '#places','#destination','#category','#guides','#imageType'].forEach(id => {
                HSCore.components.HSTomSelect.init(id, {
                    maxOptions: 250,
                    placeholder: `Select ${id.replace('#', '').replace('_', ' ')}`
                });
            });
        });

        document.addEventListener('DOMContentLoaded', function () {
            document.querySelectorAll('[data-hs-step-form-next-options]').forEach(button => {
                button.addEventListener('click', function () {
                    const targetSelector = JSON.parse(button.getAttribute('data-hs-step-form-next-options')).targetSelector;
                    goToStep(targetSelector);
                });
            });

            document.querySelectorAll('[data-hs-step-form-prev-options]').forEach(button => {
                button.addEventListener('click', function () {
                    const targetSelector = JSON.parse(button.getAttribute('data-hs-step-form-prev-options')).targetSelector;
                    goToStep(targetSelector);
                });
            });

            function goToStep(targetSelector) {
                document.querySelectorAll('.step-content-section').forEach(section => {
                    section.classList.add('d-none');
                });

                const targetStep = document.querySelector(targetSelector);
                if (targetStep) {
                    targetStep.classList.remove('d-none');
                }

                document.querySelectorAll('#addPackageStepFormProgress .step-item').forEach(step => {
                    step.classList.remove('active');
                });

                const stepLink = document.querySelector(`[data-hs-step-form-next-options*="${targetSelector}"]`);
                if (stepLink) {
                    stepLink.closest('.step-item').classList.add('active');
                }
            }

            goToStep('#stepGeneralInfo');
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make(template().'layouts.user', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ygnbmjdo/safarix/resources/views/themes/adventra/user/package/add.blade.php ENDPATH**/ ?>