<?php if(isset($tour_discover) && !empty($tour_discover['single'])): ?>
    <section class="tour-descover-section section-padding fix bg-cover" style="background-image: url(<?php echo e(getFile($tour_discover['single']['media']->image->driver, $tour_discover['single']['media']->image->path)); ?>);">
        <div class="container">
            <div class="tour-discover-wrapper">
                <div class="row g-4">
                    <div class="col-xl-5">
                        <div class="tour-content lg-center">
                            <div class="section-title">
                                <span class="wow fadeInUp"><?php echo e($tour_discover['single']['title'] ?? ''); ?></span>
                                <h2 class="wow fadeInUp" data-wow-delay=".3s"><?php echo e($tour_discover['single']['sub_title_one']?? ''); ?> <br><?php echo e($tour_discover['single']['sub_title_two'] ?? ''); ?></h2>
                                <p class="mt-3 mt-mb-0 wow fadeInUp" data-wow-delay=".5s">
                                    <?php echo e($tour_discover['single']['description_one'] ?? ''); ?> <br> <?php echo e($tour_discover['single']['description_two'] ?? ''); ?> <br>
                                    <?php echo e($tour_discover['single']['description_three'] ?? ''); ?>

                                </p>
                            </div>
                            <div class="tour-button mt-3">
                                <a href="<?php echo e(route('package')); ?>" class="theme-btn wow fadeInUp" data-wow-delay=".5s">
                                    <span><?php echo e($tour_discover['single']['button'] ?? 'Explore More'); ?></span> <i class="far fa-long-arrow-right"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-7">
                        <div class="swiper tour-slider">
                            <div class="swiper-wrapper">
                                <?php $__currentLoopData = $tour_discover['packages'] ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="swiper-slide">
                                        <div class="tour-card-item">
                                            <div class="tour-image" >
                                                <img src="<?php echo e(getFile($package->thumb_driver, $package->thumb)); ?>" alt="<?php echo e($package->title ?? ''); ?>">
                                            </div>
                                            <div class="tour-content">
                                                <h6><?php echo app('translator')->get('From'); ?> <span><?php echo e(discountPrice($package)); ?></span>
                                                    <?php if($package->discount == 1): ?>
                                                        <del><?php echo e(currencyPosition($package->adult_price)); ?></del>
                                                    <?php endif; ?>
                                                </h6>
                                                <h4>
                                                    <a href="<?php echo e(route('package.details', $package->slug)); ?>">
                                                        <?php echo e(str_replace('&amp;', '&', $package->title ?? '')); ?>

                                                    </a>
                                                </h4>
                                                <ul>
                                                    <li>
                                                        <i class="far fa-map-marker-alt"></i>
                                                        <?php echo e($package->address ?? ''); ?>

                                                    </li>
                                                </ul>
                                                <div class="list">
                                                    <ul>
                                                        <li>
                                                            <i class="far fa-calendar"></i>
                                                            <?php echo e($package->duration); ?>

                                                        </li>
                                                    </ul>
                                                    <div class="d-flex align-items-center gap-1">
                                                        <?php echo displayStarRating($package->avg_rating); ?>

                                                        <span>(<?php echo e($package->reviews_count ?? 0); ?>)</span>
                                                    </div>

                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                        <div class="swiper-dot4 mt-5">
                            <div class="dot"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php endif; ?>

<?php /**PATH /home/ygnbmjdo/safarix/resources/views/themes/adventra/sections/tour_discover.blade.php ENDPATH**/ ?>