
<?php $__env->startSection('page_title', __('Blog Category')); ?>
<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="page-header">
            <div class="row align-items-end">
                <div class="col-sm mb-2 mb-sm-0">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb breadcrumb-no-gutter">
                            <li class="breadcrumb-item">
                                <a class="breadcrumb-link" href="javascript:void(0)">
                                    <?php echo app('translator')->get('Dashboard'); ?>
                                </a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page"><?php echo app('translator')->get('Manage Blog'); ?></li>
                        </ol>
                    </nav>
                    <h1 class="page-header-title"><?php echo app('translator')->get('Blogs'); ?></h1>
                </div>
            </div>
        </div>
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h4 class="card-title m-0"><?php echo app('translator')->get('Blogs'); ?></h4>
                <a href="<?php echo e(route('admin.blogs.create')); ?>" class="btn btn-primary"><?php echo app('translator')->get('Add Blogs'); ?></a>
            </div>

            <div class="table-responsive">
                <table class="table table-thead-bordered table-nowrap table-align-middle card-table">
                    <thead class="thead-light">
                    <tr>
                        <th><?php echo app('translator')->get('No.'); ?></th>
                        <th><?php echo app('translator')->get('Title'); ?></th>
                        <th><?php echo app('translator')->get('Status'); ?></th>
                        <th class="text-center">
                            <?php $__currentLoopData = $allLanguage; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <img class="avatar avatar-xss avatar-square me-2"
                                     src="<?php echo e(getFile($language->flag_driver, $language->flag)); ?>"
                                     alt="<?php echo e($language->name); ?> Flag">
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </th>
                        <th><?php echo app('translator')->get('Action'); ?></th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e($loop->index + 1); ?></td>
                            <td>
                                <?php echo app('translator')->get(optional($blog->details)->title); ?>
                            </td>
                            <td>
                                <?php if($blog->status == 1): ?>
                                    <span class="badge bg-soft-success text-success">
                                        <span class="legend-indicator bg-success"></span><?php echo app('translator')->get('Active'); ?>
                                    </span>
                                <?php elseif($blog->status == 0): ?>
                                    <span class="badge bg-soft-warning text-warning">
                                        <span class="legend-indicator bg-warning"></span><?php echo app('translator')->get('Inactive'); ?>
                                    </span>
                                <?php else: ?>
                                    <span class="badge bg-soft-info text-info">
                                        <span class="legend-indicator bg-info"></span><?php echo app('translator')->get('Unknown'); ?>
                                    </span>
                                <?php endif; ?>
                            </td>
                            <td class="text-center">
                                <?php
                                    $blogDetailsAll = \App\Models\BlogDetails::where('blog_id',$blog->id)->pluck('language_id')->toArray();
                                ?>

                                <?php if($blog->type !== 2): ?>
                                    <?php $__currentLoopData = $allLanguage; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if(in_array($language->id,$blogDetailsAll)): ?>
                                            <a href="<?php echo e(route('admin.blog.edit', [$blog->id, $language->id])); ?>"
                                               class="btn btn-white btn-icon btn-sm flag-btn"> <i
                                                    class="bi bi-check2"></i></a>
                                        <?php else: ?>
                                            <a href="<?php echo e(route('admin.blog.edit', [$blog->id, $language->id])); ?>"
                                               class="btn btn-white btn-icon btn-sm flag-btn"
                                               target="_blank"> <i class="bi-pencil"></i></a>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php else: ?>
                                    N/A
                                <?php endif; ?>
                            </td>
                            <td>
                                <div class="btn-group" role="group">
                                    <a class="btn btn-white btn-sm" href="<?php echo e(route('admin.blog.edit', [$blog->id, $defaultLanguage->id])); ?>">
                                        <i class="bi-pencil-fill me-1"></i> Edit
                                    </a>
                                    <div class="btn-group">
                                        <button type="button" class="btn btn-white btn-icon btn-sm dropdown-toggle dropdown-toggle-empty" id="productsEditDropdown1" data-bs-toggle="dropdown" aria-expanded="false"></button>
                                        <div class="dropdown-menu dropdown-menu-end mt-1" aria-labelledby="productsEditDropdown1">
                                            <a class="dropdown-item statusBtn text-dark"
                                               href="javascript:void(0)"
                                               data-route="<?php echo e(route("admin.blog.status", $blog->id)); ?>"
                                               data-bs-toggle="modal" data-bs-target="#statusModal">
                                                <i class="bi-check-circle dropdown-item-icon text-dark"></i> <?php echo app('translator')->get("Status"); ?>
                                            </a>
                                            <a class="dropdown-item"
                                               href="<?php echo e(route("admin.blog.seo", $blog->id)); ?>">
                                                <i class="fa-light fa-magnifying-glass dropdown-item-icon"></i>
                                                <?php echo app('translator')->get("SEO"); ?>
                                            </a>
                                            <a class="dropdown-item deleteBtn text-danger"
                                               href="javascript:void(0)"
                                               data-route="<?php echo e(route("admin.blogs.destroy", $blog->id)); ?>"
                                               data-bs-toggle="modal" data-bs-target="#deleteModal">
                                                <i class="bi-trash dropdown-item-icon text-danger"></i> <?php echo app('translator')->get("Delete"); ?>
                                            </a>

                                        </div>
                                    </div>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr class="odd">
                            <td valign="top" colspan="8" class="dataTables_empty">
                                <div class="text-center p-4">
                                    <img class="mb-3 dataTables-image"
                                         src="<?php echo e(asset('assets/admin/img/oc-error.svg')); ?>" alt="Image Description"
                                         data-hs-theme-appearance="default">
                                    <img class="mb-3 dataTables-image"
                                         src="<?php echo e(asset('assets/admin/img/oc-error-light.svg')); ?>"
                                         alt="Image Description" data-hs-theme-appearance="dark">
                                    <p class="mb-0"><?php echo app('translator')->get("No data to show"); ?></p>
                                </div>
                            </td>
                        </tr>
                    <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <div class="modal fade" id="statusModal" tabindex="-1" role="dialog" aria-labelledby="statusModalLabel"
         data-bs-backdrop="static"
         aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="statusModalLabel"><i
                            class="bi bi-check2-square"></i> <?php echo app('translator')->get('Confirmation'); ?></h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form action="" method="get" class="setStatusRoute">
                    <?php echo method_field('get'); ?>
                    <div class="modal-body">
                        <p><?php echo app('translator')->get('Are you sure you want to change the status of this item? This action cannot be undone and will affect the current status of the item.'); ?></p>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-white" data-bs-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                        <button type="submit" class="btn btn-primary"><?php echo app('translator')->get('Confirm'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Delete Modal -->
    <div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel"
         data-bs-backdrop="static"
         aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="deleteModalLabel"><i
                            class="bi bi-check2-square"></i> <?php echo app('translator')->get("Confirmation"); ?></h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form action="" method="post" class="setRoute">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field("delete"); ?>
                    <div class="modal-body">
                        <p><?php echo app('translator')->get("Do you want to delete this Blog"); ?></p>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-white" data-bs-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                        <button type="submit" class="btn btn-primary"><?php echo app('translator')->get('Confirm'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- End Delete Modal -->

<?php $__env->stopSection(); ?>




<?php $__env->startPush('script'); ?>
    <script>
        "use script";
        $(document).ready(function () {
            $('.deleteBtn').on('click', function () {
                let route = $(this).data('route');
                $('.setRoute').attr('action', route);
            })
            $('.statusBtn').on('click', function () {
                let route = $(this).data('route');
                $('.setStatusRoute').attr('action', route);
            })
        })
    </script>
<?php $__env->stopPush(); ?>




<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ygnbmjdo/safarix/resources/views/admin/blogs/list.blade.php ENDPATH**/ ?>