<div id="payment_collection" class="card">
    <div class="card-header">
        <h2 class="card-title h4"><?php echo app('translator')->get('Payment Collection'); ?></h2>
    </div>
    <div class="card-body">
        <label class="row form-check form-switch mb-4" for="paymentCollectionSwitch">
                <span class="col-8 col-sm-9 ms-0">
                  <span class="d-block text-dark"><?php echo app('translator')->get('Direct Payment Received'); ?></span>
                  <span
                      class="d-block fs-5"><?php echo app('translator')->get('If you disable direct payments, vendors will no longer receive payments directly; instead, all payments will be routed through the admin.'); ?></span>
                </span>
            <span class="col-4 col-sm-3 text-end">
                 <input type="hidden" name="payment_collection" value="0">
                  <input type="checkbox" class="form-check-input" name="payment_collection" id="paymentCollectionSwitch" value="1" <?php echo e($user->payment_collection_system == 1 ? 'checked' : ''); ?>>
                </span>
        </label>
    </div>
</div>

<?php $__env->startPush('script'); ?>
    <script>
        $(document).ready(function () {
            $('#paymentCollectionSwitch').on('change', function () {
                let isChecked = $(this).is(':checked') ? 1 : 0;
                let userId = '<?php echo e($user->id); ?>';

                $.ajax({
                    url: '<?php echo e(route('admin.user.set.payment.collection')); ?>',
                    method: 'POST',
                    data: {
                        _token: '<?php echo e(csrf_token()); ?>',
                        payment_collection: isChecked,
                        user_id: userId
                    },
                    success: function (response) {
                        Notiflix.Notify.success(response.message);
                    },
                    error: function (xhr) {
                        Notiflix.Notify.failure('Failed to update payment collection. Please try again.');
                    }
                });
            });
        });
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/ygnbmjdo/safarix/resources/views/admin/user_management/components/payment_collection.blade.php ENDPATH**/ ?>