# Getting Involved

Thanks for your interest in the project, we'd love to have you involved! Check out sections below to find out more about what to do next...

## Submitting an Issue

If you've seen something that is or may seem like a bug or a mistake in documentation, or you simply have a suggestion for a new feature, please go ahead and open [an issue][issue-link].
Include as much information as you have.

Before you submit your issue, please do the archive search first, as there may be a similar question that's already been answered or is pending a response.

If you haven't found any related issues among the already asked, feel free to open a new one.

For new feature requests, any sort of bug, anomaly, issue, etc. please try to provide information, as structured below.
You don't have to follow it to the letter, but having it structured like below may save us a lot of time to pinpoint and fix the issue quicker.

### New issue structure (bugs, anomalies, improvements...)
Providing the following information will increase the chances of your issue being dealt with quickly:

* **Short TO-THE-POINT Overview** - what seems to be the issue.
* **Description** - more detailed explanation of the issue. The stack trace in cases where it is applicable.
* **Which version(s)** - which library version(s) you used when the issue occurred.
* **Environment** - is this a problem with all development/testing/production environments or only a specific one(s)?
* **Reproducing** - how did it happen? Is it an isolated anomaly, can you recreate it, what are the steps to recreate it?
* **Related Issues** - is there something similar to this issue that has been reported before? If so, please tag that issue(s) as a reference.
* **Suggest a Fix** - this code is auto generated, but perhaps you can provide us with your code sample as a fix to the part of the code that is causing the bug.

## Pull requests disclaimer
We will not be accepting any pull requests, as the source code within this repository is **auto generated**.
Any change needs to be made by us within the library generation configuration.
Having said that, we still fully encourage you to submit an issue, since that will help us track it and keep you up to date.

[issue-link]: https://github.com/infobip/infobip-api-php-client/issues/new
